
import gurobi

def solve_sandwich_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(lb=45, ub=80, name="peanut_butter_sandwiches")
    y = model.addVar(lb=65, ub=100, name="chocolate_spread_sandwiches")

    # Objective function: Maximize 3x + 2y
    model.setObjective(3 * x + 2 * y, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x + y <= 150, name="bread_constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${3 * x.varValue + 2 * y.varValue}")
    else:
        print("No optimal solution found")

solve_sandwich_problem()
