
import gurobipy as gp

# Create a new model
m = gp.Model("sandwich_optimization")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tuna_sandwiches")
y = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_sandwiches")

# Set objective function
m.setObjective(5*x + 7*y, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x + 25*y >= 100, "protein_constraint")
m.addConstr(25*x + 15*y >= 150, "fat_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal}")
    print(f"Tuna Sandwiches: {x.x}")
    print(f"Chicken Sandwiches: {y.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

