
from gurobipy import *

# Create a model
m = Model("Weight_Gain_Problem")

# Define decision variables
T = m.addVar(vtype=GRB.CONTINUOUS, name="tuna_sandwiches")
C = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_sandwiches")

# Set the objective function to minimize cost
m.setObjective(5*T + 7*C, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*T + 25*C >= 100, "protein_requirement")
m.addConstr(25*T + 15*C >= 150, "fat_requirement")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of tuna salad sandwiches: {T.x}")
    print(f"Number of chicken salad sandwiches: {C.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
