
import gurobi

def solve_sandwich_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    T = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Tuna")
    C = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Chicken")

    # Objective function: minimize cost
    model.setObjective(5*T + 7*C, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20*T + 25*C >= 100, name="Protein")
    model.addConstr(25*T + 15*C >= 150, name="Fat")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Tuna = {T.varValue}, Chicken = {C.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_sandwich_problem()
