
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Countertop Production")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="marble")  # Marble countertops
y = m.addVar(vtype=GRB.CONTINUOUS, name="granite") # Granite countertops

# Set objective function
m.setObjective(500*x + 750*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + 1.5*y <= 300, "cutting_time")
m.addConstr(2*x + 3*y <= 500, "polishing_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Marble Countertops: {x.x}")
    print(f"  Granite Countertops: {y.x}")
    print(f"  Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

