
from gurobipy import *

# Create a model
m = Model("Countertop_Production")

# Define variables
M = m.addVar(vtype=GRB.CONTINUOUS, name="Marble_Countertops")
G = m.addVar(vtype=GRB.CONTINUOUS, name="Granite_Countertops")

# Set the objective function: Maximize profit
m.setObjective(500*M + 750*G, GRB.MAXIMIZE)

# Add constraints
m.addConstr(M + 1.5*G <= 300, "Cutting_Time_Constraint")
m.addConstr(2*M + 3*G <= 500, "Polishing_Time_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Marble Countertops: {M.x}")
    print(f"Granite Countertops: {G.x}")
    print(f"Maximum Profit: ${500*M.x + 750*G.x:.2f}")
else:
    print("No optimal solution found.")

