
import gurobi

def solve_countertop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    M = model.addVar(lb=0, name="Marble_Countertops")
    G = model.addVar(lb=0, name="Granite_Countertops")

    # Define the objective function
    model.setObjective(500*M + 750*G, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(M + 1.5*G <= 300, name="Cutting_Constraint")
    model.addConstr(2*M + 3*G <= 500, name="Polishing_Constraint")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Marble Countertops: {M.varValue}")
        print(f"Granite Countertops: {G.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible or has an error.")

solve_countertop_problem()
