
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("phone_production")

    # Create variables
    x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="touchscreen") # allowing fractional phones for now
    y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="flip")

    # Set objective
    m.setObjective(150 * x + 200 * y, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(30 * x + 80 * y <= 5000, "hardware_setup")
    m.addConstr(20 * x + 15 * y <= 3750, "software_verification")
    m.addConstr(x >= 0, "touchscreen_nonneg")
    m.addConstr(y >= 0, "flip_nonneg")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal Touchscreen Phones: {x.x}")
        print(f"Optimal Flip Phones: {y.x}")
        print(f"Optimal Profit: ${m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error. Check if the Gurobi environment is set up correctly.')

