
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="touchscreen_phones")
y = model.addVar(lb=0, name="flip_phones")

# Define the objective function
model.setObjective(150*x + 200*y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(30*x + 80*y <= 5000, name="hardware_setup")
model.addConstr(20*x + 15*y <= 3750, name="software_verification")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Touchscreen phones: {x.varValue}")
    print(f"Flip phones: {y.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
