
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Fruit_Optimization")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Peaches_Acres")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Nectarines_Acres")

# Set objective function
m.setObjective(300*x + 350*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 30, "Land_Constraint")
m.addConstr(40*x + 50*y <= 1350, "BugSpray_Cost_Constraint")
m.addConstr(50*x + 70*y <= 2000, "Time_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of peaches")
    print(f"Plant {y.x:.2f} acres of nectarines")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

