
from gurobipy import *

# Create a new model
m = Model("Optimal_Peach_Nectarine_Growth")

# Decision variables
peaches = m.addVar(lb=0, name="Peaches")
nectarines = m.addVar(lb=0, name="Nectarines")

# Objective function: Maximize profit
m.setObjective(300*peaches + 350*nectarines, GRB.MAXIMIZE)

# Constraints
m.addConstr(40*peaches + 50*nectarines <= 1350, "Bug_Spray_Cost")
m.addConstr(50*peaches + 70*nectarines <= 2000, "Spraying_Time")
m.addConstr(peaches + nectarines <= 30, "Land_Availability")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Peaches: {peaches.x}")
    print(f"Nectarines: {nectarines.x}")
    print(f"Max Profit: ${300*peaches.x + 350*nectarines.x:.2f}")
else:
    print("No optimal solution found")
