
import gurobipy as gp

# Create a new model
m = gp.Model("Peach_Nectarine_Optimization")

# Define decision variables
x = m.addVar(name="peaches", lb=0)
y = m.addVar(name="nectarines", lb=0)

# Objective function: maximize profit
m.setObjective(300*x + 350*y, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y <= 30, name="land_constraint")
m.addConstr(40*x + 50*y <= 1350, name="bug_spray_cost_constraint")
m.addConstr(50*x + 70*y <= 2000, name="spraying_time_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.varValue:.2f}, y = {y.varValue:.2f}")
    print(f"Maximum profit: ${300*x.varValue + 350*y.varValue:.2f}")
else:
    print("No optimal solution found")
