
import gurobipy as gp

# Create a new model
model = gp.Model("WatchProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="round_watches")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="square_watches")

# Set objective function
model.setObjective(1000*x + 1250*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 5, "team_A_limit")
model.addConstr(y <= 6, "team_B_limit")
model.addConstr(x + y <= 8, "quality_check_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Round Watches (x): {x.x}")
    print(f"Square Watches (y): {y.x}")
    print(f"Optimal Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

