
from gurobipy import *

# Create a new model
m = Model("Watch_Problem")

# Define the decision variables
x = m.addVar(lb=0, ub=5, vtype=GRB.INTEGER, name="round_watches")
y = m.addVar(lb=0, ub=6, vtype=GRB.INTEGER, name="square_watches")

# Set the objective function to maximize profit
m.setObjective(1000*x + 1250*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x <= 5, "Team_A_Capacity")
m.addConstr(y <= 6, "Team_B_Capacity")
m.addConstr(x + y <= 8, "Quality_Checking_Capacity")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Round watches: {x.x}")
    print(f"Square watches: {y.x}")
    print(f"Total profit: ${1000*x.x + 1250*y.x}")
else:
    print("No optimal solution found")
