
import gurobi

def solve_watch_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    R = model.addVar(lb=0, ub=5, name="Round_Watches")
    S = model.addVar(lb=0, ub=6, name="Square_Watches")

    # Objective function: Maximize profit
    model.setObjective(1000*R + 1250*S, gurobi.GRB.MAXIMIZE)

    # Quality checking constraint
    model.addConstraint(R + S <= 8, name="Quality_Checking")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Round Watches = {R.varValue}, Square Watches = {S.varValue}")
        print(f"Max Profit: ${model.objVal}")
    else:
        print("The model is infeasible.")

solve_watch_problem()
