
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create decision variables
x = m.addVar(lb=0, name="clean_water")  # Investment in clean water
y = m.addVar(lb=0, name="electricity")  # Investment in electricity

# Set objective function
m.setObjective(1.9 * x + 2.3 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 5500, "budget")
m.addConstr(x >= 1000, "min_water")
m.addConstr(0.7 * y - 0.3 * x >= 0, "min_electricity")


# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Invest ${x.x:.2f} in clean water")
    print(f"Invest ${y.x:.2f} in electricity")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

