
from gurobipy import *

# Create a model
m = Model("Infrastructure_Investment")

# Define the decision variables
x_c = m.addVar(name='clean_water', lb=0)  # Amount invested in clean water
x_e = m.addVar(name='electricity', lb=0)   # Amount invested in electricity

# Set the objective function
m.setObjective(1.9*x_c + 2.3*x_e, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_c + x_e <= 5500, name='budget')  # Total budget constraint
m.addConstr(x_c >= 1000, name='min_clean_water')  # Minimum clean water investment
m.addConstr(x_e >= (3/7)*x_c, name='min_electricity_percentage')  # Minimum electricity percentage

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Clean Water Investment: {x_c.x}")
    print(f"Electricity Investment: {x_e.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
