
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="clean_water", lb=0)  # Investment in clean water
    y = model.addVar(name="electricity", lb=0)  # Investment in electricity

    # Objective function: Maximize profit
    model.setObjective(1.9 * x + 2.3 * y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(x + y <= 5500, name="budget_constraint")

    # Clean water investment constraint
    model.addConstr(x >= 1000, name="clean_water_constraint")

    # Electricity investment constraint
    model.addConstr(y >= 0.3 * (x + y), name="electricity_constraint")

    # Solve the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Investment in clean water: ${x.varValue:.2f}")
        print(f"Investment in electricity: ${y.varValue:.2f}")
        print(f"Total Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
