
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Vessel Production")

# Create variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="general_purpose")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pharmaceutical")
z = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pressure")

# Set objective function
model.setObjective(2000*x + 3000*y + 4500*z, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3.5*x + 4*y + 2*z <= 120, "iron_ore_constraint")
model.addConstr(2*x + 5*y + 3.5*z <= 70, "zinc_ore_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"General Purpose Vessels: {x.x}")
    print(f"Pharmaceutical Vessels: {y.x}")
    print(f"Pressure Vessels: {z.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

