
from gurobipy import *

# Create a new model
m = Model("Vessel_Production")

# Define the decision variables
G = m.addVar(name='General_Purpose_Vessels', vtype=GRB.CONTINUOUS, lb=0)
P = m.addVar(name='Pharmaceutical_Vessels', vtype=GRB.CONTINUOUS, lb=0)
Pr = m.addVar(name='Pressure_Vessels', vtype=GRB.CONTINUOUS, lb=0)

# Define the objective function
m.setObjective(2000*G + 3000*P + 4500*Pr, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.5*G + 4*P + 2*Pr <= 120, name='Iron_Ore_Constraint')
m.addConstr(2*G + 5*P + 3.5*Pr <= 70, name='Zinc_Ore_Constraint')

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective Value: {m.objVal}")
