
import gurobipy as gp

# Create a new model
model = gp.Model("Vessel_Production")

# Decision variables
x1 = model.addVar(name="general_purpose_vessels", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="pharmaceutical_vessels", lb=0, vtype=gp.GRB.CONTINUOUS)
x3 = model.addVar(name="pressure_vessels", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function
model.setObjective(2000*x1 + 3000*x2 + 4500*x3, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3.5*x1 + 4*x2 + 2*x3 <= 120, name="iron_ore_constraint")
model.addConstr(2*x1 + 5*x2 + 3.5*x3 <= 70, name="zinc_ore_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"General Purpose Vessels: {x1.varValue}")
    print(f"Pharmaceutical Vessels: {x2.varValue}")
    print(f"Pressure Vessels: {x3.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
