
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("cocktail_mix")

# Create variables
x = m.addVar(lb=0, name="white_cocktail")
y = m.addVar(lb=0, name="green_cocktail")

# Set objective function
m.setObjective(5.5 * x + 12 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.07 * x + 0.02 * y >= 5, "alcohol_constraint")
m.addConstr(0.10 * x + 0.25 * y >= 25, "sugar_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"White cocktail: {x.x:.2f} kg")
    print(f"Green cocktail: {y.x:.2f} kg")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

