
from gurobipy import *

# Create a new model
m = Model("Cocktail_Mixing")

# Define the decision variables
W = m.addVar(name="White_Cocktail", vtype=GRB.CONTINUOUS, lb=0)
G = m.addVar(name="Green_Cocktail", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function: minimize total cost
m.setObjective(5.5*W + 12*G, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.07*W + 0.02*G >= 5, name="Alcohol_Constraint")
m.addConstr(0.10*W + 0.25*G >= 25, name="Sugar_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"White Cocktail: {W.x} kg")
    print(f"Green Cocktail: {G.x} kg")
    print(f"Total Cost: ${5.5*W.x + 12*G.x}")
else:
    print("No optimal solution found")

