
import gurobi

def solve_cocktail_mixing_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    W = model.addVar(lb=0, name="White_Cocktail")  # Amount of white cocktail
    G = model.addVar(lb=0, name="Green_Cocktail")  # Amount of green cocktail

    # Objective function: Minimize cost
    model.setObjective(5.5 * W + 12 * G, gurobi.GRB.MINIMIZE)

    # Constraints
    # Alcohol requirement
    model.addConstr(0.07 * W + 0.02 * G >= 5, name="Alcohol_Requirement")
    # Sugar requirement
    model.addConstr(0.10 * W + 0.25 * G >= 25, name="Sugar_Requirement")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Amount of white cocktail: {W.varValue} kg")
        print(f"Amount of green cocktail: {G.varValue} kg")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("The model is infeasible or no solution exists.")

# Run the function
solve_cocktail_mixing_problem()
