
import gurobipy as gp

# Create a new model
model = gp.Model("Iota Staffing")

# Create decision variables
F = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="F") # Full-time employees
P = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="P") # Part-time employees

# Set objective function
model.setObjective(800*F + 400*P, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(F + P >= 60, "Total Employees")
model.addConstr(F >= 40, "Min Full-time")
model.addConstr(F >= (1/3)*P, "Full-time Ratio")
model.addConstr(800*F + 400*P <= 30000, "Wage Bill")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Full-time Employees: {F.x}")
    print(f"Number of Part-time Employees: {P.x}")
    print(f"Minimum Weekly Wage Bill: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

