
from gurobipy import *

# Create a new model
m = Model("Iota_Software_Optimization")

# Define the decision variables
x_f = m.addVar(vtype=GRB.CONTINUOUS, name="full_time_employees")
x_p = m.addVar(vtype=GRB.CONTINUOUS, name="part_time_employees")

# Set the objective function
m.setObjective(800*x_f + 400*x_p, GRB.MINIMIZE)

# Add constraints
m.addConstr(x_f + x_p >= 60, "total_employees")
m.addConstr(x_f >= 40, "full_time_minimum")
m.addConstr(x_f >= (1/3)*x_p, "full_time_part_time_ratio")
m.addConstr(800*x_f + 400*x_p <= 30000, "wage_bill_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Full-time employees:", x_f.x)
    print("Part-time employees:", x_p.x)
    print("Total wage bill: $", 800*x_f.x + 400*x_p.x)
else:
    print("No optimal solution found. Status:", m.status)

