
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    x = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="full_time_employees")
    y = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="part_time_employees")

    # Objective function: Minimize the wage bill
    model.setObjective(800*x + 400*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x + y >= 60, name="total_employees")
    model.addConstr(x >= 40, name="full_time_requirement")
    model.addConstr(3*x >= y, name="full_time_to_part_time_ratio")
    model.addConstr(800*x + 400*y <= 30000, name="wage_bill")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Full-time employees: {x.varValue}")
        print(f"Part-time employees: {y.varValue}")
        print(f"Minimum wage bill: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
