
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("James_Flower_Problem")

# Create decision variables
x = m.addVar(lb=0, name="asters")  # Square feet of asters
y = m.addVar(lb=0, name="stonecrops")  # Square feet of stonecrops

# Set objective function
m.setObjective(60*x + 80*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 120, "area")
m.addConstr(20*x + 45*y <= 5000, "budget")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} square feet of asters")
    print(f"Plant {y.x:.2f} square feet of stonecrops")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

