
from gurobipy import *

# Create a new model
m = Model("James_Flower_Profit")

# Define the variables
x = m.addVar(lb=0, name="aster_area")
y = m.addVar(lb=0, name="stonecrop_area")

# Set the objective function to maximize profit
m.setObjective(60*x + 80*y, GRB.MAXIMIZE)

# Add constraints: field size and budget
m.addConstr(x + y <= 120, "field_size")
m.addConstr(20*x + 45*y <= 5000, "budget")

# Optimize the model
m.optimize()

# Check if an optimal solution was found
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
