
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="Aster_Flowers")  # Area for aster flowers
    x2 = model.addVar(lb=0, name="Stonecrops")  # Area for stonecrops

    # Objective function: Maximize profit
    model.setObjective(60 * x1 + 80 * x2, gurobi.GRB.MAXIMIZE)

    # Field size constraint
    model.addConstr(x1 + x2 <= 120, name="Field_Size")

    # Budget constraint
    model.addConstr(20 * x1 + 45 * x2 <= 5000, name="Budget")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Aster Flowers: {x1.varValue} sq ft")
        print(f"Stonecrops: {x2.varValue} sq ft")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
