
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("car_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="x") # Number of SUVs
y = m.addVar(vtype=GRB.CONTINUOUS, name="y") # Number of sedans

# Set objective function
m.setObjective(10000*x + 9000*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(200*x + 150*y <= 20000, "manufacturing_constraint")
m.addConstr(120*x + 100*y <= 10000, "testing_constraint")
m.addConstr(x >= 0, "x_non_negativity")
m.addConstr(y >= 0, "y_non_negativity")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of SUVs to produce (x): {x.x}")
    print(f"Number of Sedans to produce (y): {y.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

