
from gurobipy import *

# Create a new model
m = Model("Car_Production")

# Define the decision variables
x1 = m.addVar(name="SUVs", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Sedans", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function: Maximize profit
m.setObjective(10000*x1 + 9000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(200*x1 + 150*x2 <= 20000, name="Manufacturing_Time")
m.addConstr(120*x1 + 100*x2 <= 10000, name="Testing_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"SUVs to produce: {x1.x}")
    print(f"Sedans to produce: {x2.x}")
    print(f"Maximum profit: ${10000*x1.x + 9000*x2.x:.2f}")
else:
    print("No optimal solution found.")
