
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    S = model.addVar(name="SUV", lb=0, vtype=gurobi.GRB.INTEGER)
    D = model.addVar(name="sedan", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(10000*S + 9000*D, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(200*S + 150*D <= 20000, name="manufacturing_time")
    model.addConstr(120*S + 100*D <= 10000, name="testing_time")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of SUVs: {S.varValue}")
        print(f"Optimal number of sedans: {D.varValue}")
        print(f"Maximal profit: ${model.objVal}")
    else:
        print("The problem is infeasible")

if __name__ == "__main__":
    solve_production_problem()
