
import gurobipy as gp

# Create a new model
model = gp.Model("BagProduction")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="laptop_bags")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="briefcases")

# Set objective function
model.setObjective(80*x + 50*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*x + 10*y <= 300, "sewing_time")
model.addConstr(5*x + 9*y <= 500, "painting_time")
model.addConstr(x >= 0, "laptop_bags_non_negative")
model.addConstr(y >= 0, "briefcases_non_negative")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Laptop Bags: {x.x}")
    print(f"Number of Briefcases: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

