
from gurobipy import *

# Create a new model
m = Model("Factory_Optimization")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="laptop_bags")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="briefcases")

# Set the objective function to maximize profit
m.setObjective(80*x + 50*y, GRB.MAXIMIZE)

# Add constraints for sewing and painting time
m.addConstr(12*x + 10*y <= 300, "sewing_time")
m.addConstr(5*x + 9*y <= 500, "painting_time")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of laptop bags: {x.x}")
    print(f"Number of briefcases: {y.x}")
    print(f"Total profit: ${80*x.x + 50*y.x:.2f}")
else:
    print("No optimal solution found")

