
import gurobi as gp

# Create a new model
model = gp.Model("Laptop_Bags_and_Briefcases")

# Define the variables
L = model.addVar(name="Laptop_Bags", lb=0, vtype=gp.GRB.CONTINUOUS)
B = model.addVar(name="Briefcases", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(80*L + 50*B, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*L + 10*B <= 300, name="Sewing_Time")
model.addConstr(5*L + 9*B <= 500, name="Painting_Time")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Laptop Bags: {L.varValue}, Briefcases: {B.varValue}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
