
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Avian_Advertising")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="concert_commercials")
y = m.addVar(vtype=GRB.CONTINUOUS, name="cinema_commercials")

# Set objective function
m.setObjective(80000 * x + 30000 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * x + 5 * y >= 86, "young_girls")
m.addConstr(4 * x + 45 * y >= 72, "middle_aged_women")
m.addConstr(x >= 0, "concert_non_neg")
m.addConstr(y >= 0, "cinema_non_neg")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Number of concert commercials: {x.x}")
    print(f"Number of cinema commercials: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

