
from gurobipy import *

# Create a model
m = Model("Avian_Cosmetics")

# Define the decision variables
x_c = m.addVar(vtype=GRB.CONTINUOUS, name="concert_commercials")
x_cin = m.addVar(vtype=GRB.CONTINUOUS, name="cinema_commercials")

# Set the objective function
m.setObjective(80000*x_c + 30000*x_cin, GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x_c + 5*x_cin >= 86, "young_girls_constraint")
m.addConstr(4*x_c + 45*x_cin >= 72, "middle_aged_women_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of concert commercials: {x_c.x}")
    print(f"Number of cinema commercials: {x_cin.x}")
    print(f"Total cost: ${80000*x_c.x + 30000*x_cin.x}")
else:
    print("No optimal solution found.")

