
import gurobi

def avian_cosmetics_advertising():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    x_c = model.addVar(name="concert_commercials", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x_cin = model.addVar(name="cinema_commercials", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize cost
    model.setObjective(80000*x_c + 30000*x_cin, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x_c + 5*x_cin >= 86000000, name="young_girls_constraint")
    model.addConstr(4*x_c + 45*x_cin >= 72000000, name="middle_aged_women_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Concert Commercials: {x_c.varValue}")
        print(f"Cinema Commercials: {x_cin.varValue}")
        print(f"Total Cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the model
avian_cosmetics_advertising()
