
from gurobipy import *

# Create a new model
m = Model("Painting_Company")

# Define variables
S = m.addVar(name="Students", lb=0)
F = m.addVar(name="Full-Time_Employees", lb=0)

# Set the objective function
m.setObjective(200*S + 500*F, GRB.MINIMIZE)

# Add constraints
m.addConstr(S + F >= 100, name="Total_Painters")
m.addConstr(F >= 30, name="Full-Time_Minimum")
m.addConstr(F >= 0.5 * S, name="Experience_Balance")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Students = {S.x}, Full-Time Employees = {F.x}")
    print(f"Total wage bill: ${200*S.x + 500*F.x:.2f}")
else:
    print("No optimal solution found")
