
import gurobi

def solve_painting_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    S = model.addVar(lb=0, name="Students")
    F = model.addVar(lb=0, name="Full-time_Employees")

    # Objective function: Minimize the wage bill
    model.setObjective(200 * S + 500 * F, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(S + F >= 100, name="Total_Painters")
    model.addConstr(F >= 30, name="Min_Full-time_Employees")
    model.addConstr(2 * F >= S, name="Experience_Requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Students: {S.varValue}")
        print(f"Full-time Employees: {F.varValue}")
        print(f"Minimum Wage Bill: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_painting_company_problem()
