
import gurobipy as gp

# Create a new model
model = gp.Model("RockProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oval_rocks")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rectangular_rocks")

# Set objective function
model.setObjective(7*x + 9*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 15*y <= 2000, "washing_constraint")
model.addConstr(12*x + 12*y <= 2500/12, "polishing_constraint") # Corrected constraint

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Oval Rocks: {x.x}")
    print(f"Rectangular Rocks: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

