
from gurobipy import *

# Create a model
m = Model("Rock_Collection")

# Define the variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oval_rocks")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rectangular_rocks")

# Set the objective function: Maximize profit
m.setObjective(7*x + 9*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 15*y <= 2000, "washing_time")
m.addConstr(12*x + 12*y <= 2500, "polishing_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oval rocks: {x.x}")
    print(f"Rectangular rocks: {y.x}")
    print(f"Total profit: ${7*x.x + 9*y.x:.2f}")
else:
    print("No optimal solution found")
