
import gurobi

def solve_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="oval_rocks")
    y = model.addVar(lb=0, name="rectangular_rocks")

    # Define the objective function
    model.setObjective(7 * x + 9 * y, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(10 * x + 15 * y <= 2000, name="washing_time")
    model.addConstr(12 * x + 12 * y <= 2500, name="polishing_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${7 * x.varValue + 9 * y.varValue:.2f}")
    else:
        print("No optimal solution found")

if __name__ == "__main__":
    solve_problem()
