
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bubble_tea_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="mango_drinks")
y = m.addVar(vtype=GRB.INTEGER, name="peach_drinks")

# Set objective function
m.setObjective(2*x + 3*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 150, "total_drinks")
m.addConstr(x >= 60, "min_mango")
m.addConstr(y >= 40, "min_peach")
m.addConstr(x <= 120, "max_mango")
m.addConstr(y <= 70, "max_peach")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Mango Drinks (x): {x.x}")
    print(f"Peach Drinks (y): {y.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

