
from gurobipy import *

# Create a new model
m = Model("Bubble_Tea_Optimization")

# Define variables
M = m.addVar(vtype=GRB.INTEGER, name="Mango_Drinks", lb=0)
P = m.addVar(vtype=GRB.INTEGER, name="Peach_Drinks", lb=0)

# Set the objective function to maximize profit
m.setObjective(2*M + 3*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(M + P <= 150, "Total_Drinks")
m.addConstr(M >= 60, "Minimum_Mango")
m.addConstr(P >= 40, "Minimum_Peach")
m.addConstr(M <= 120, "Maximum_Mango")
m.addConstr(P <= 70, "Maximum_Peach")

# Optimize the model
m.optimize()

# Print results if the model is optimal or feasible
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mango Drinks: {M.x}")
    print(f"Peach Drinks: {P.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("No optimal solution found")

