
import gurobi

def solve_bubble_tea_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=60, ub=120, name="mango_drinks")
    y = model.addVar(lb=40, ub=70, name="peach_drinks")

    # Set the objective function to maximize profit
    model.setObjective(2 * x + 3 * y, gurobi.GRB.MAXIMIZE)

    # Add the constraint for the total number of drinks
    model.addConstr(x + y <= 150, name="total_drinks")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        # Get the optimal values for x and y
        mango_drinks = x.varValue
        peach_drinks = y.varValue
        print(f"Optimal solution: Mango drinks = {mango_drinks}, Peach drinks = {peach_drinks}")
        print(f"Maximum profit: ${2 * mango_drinks + 3 * peach_drinks}")
    else:
        print("The model is infeasible.")

solve_bubble_tea_problem()
