
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Flower_Planting")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tulips")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="orchids")

# Set objective function
m.setObjective(75*x + 105*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 120, "land_constraint")
m.addConstr(15*x + 40*y <= 1200, "budget_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of tulips")
    print(f"Plant {y.x} acres of orchids")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

