
from gurobipy import *

# Create a new model
m = Model("Flower_Grower")

# Define variables
T = m.addVar(vtype=GRB.CONTINUOUS, name="tulips", lb=0)
O = m.addVar(vtype=GRB.CONTINUOUS, name="orchids", lb=0)

# Set the objective function
m.setObjective(75*T + 105*O, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*T + 40*O <= 1200, "budget")
m.addConstr(T + O <= 120, "land")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Tulips: {T.x} acres")
    print(f"Orchids: {O.x} acres")
    print(f"Maximum Profit: ${75*T.x + 105*O.x}")
else:
    print("No optimal solution found.")
