
import gurobi

def solve_flower_planting_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    T = model.addVar(lb=0, name="Tulips")
    O = model.addVar(lb=0, name="Orchids")

    # Objective function: Maximize profit
    model.setObjective(75 * T + 105 * O, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(T + O <= 120, name="Land_Constraint")

    # Budget constraint
    model.addConstr(15 * T + 40 * O <= 1200, name="Budget_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of Tulips: {T.varValue}")
        print(f"Optimal acres of Orchids: {O.varValue}")
        print(f"Max Profit: ${model.objVal}")
    else:
        print("The problem is infeasible")

solve_flower_planting_problem()
